package ru.yandex.direct.web.entity.grid.controller;

import java.util.Collections;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

import ru.yandex.direct.web.annotations.AllowedBlockedOperatorOrUser;
import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.security.netacl.AllowNetworks;
import ru.yandex.direct.web.entity.grid.model.GridRequest;
import ru.yandex.direct.web.entity.grid.model.GridResponse;
import ru.yandex.direct.web.entity.grid.service.GridService;

import static ru.yandex.direct.common.net.NetworkName.INTERNAL;
import static ru.yandex.direct.rbac.RbacRole.AGENCY;
import static ru.yandex.direct.rbac.RbacRole.CLIENT;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_ADMIN;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_MANAGER;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.LIMITED_SUPPORT;
import static ru.yandex.direct.rbac.RbacRole.MANAGER;
import static ru.yandex.direct.rbac.RbacRole.MEDIA;
import static ru.yandex.direct.rbac.RbacRole.PLACER;
import static ru.yandex.direct.rbac.RbacRole.SUPER;
import static ru.yandex.direct.rbac.RbacRole.SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.SUPPORT;
import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

/**
 * GraphQL-эндпоинт для нового интерфейса Директа. Здесь производится только предварительная обработка запроса,
 * остальное делается в отдельном модуле libs-internal/grid-processing
 */
@ApiIgnore // не хотим показывать в swagger-е
@Controller
@ParametersAreNonnullByDefault
@AllowedBlockedOperatorOrUser
@RequestMapping("/grid")
@AllowedSubjectRoles({SUPER, SUPERREADER, SUPPORT, PLACER, MEDIA, MANAGER, AGENCY,
        INTERNAL_AD_ADMIN, INTERNAL_AD_MANAGER, INTERNAL_AD_SUPERREADER,
        LIMITED_SUPPORT, CLIENT})
public class GridController {
    private final GridService gridService;

    @Autowired
    public GridController(GridService gridService) {
        this.gridService = gridService;
    }

    /**
     * Статический интерфейс graphiql для отладки контроллера. Доступен только из внутренней сети
     */
    @GetMapping(value = "/")
    @AllowNetworks({INTERNAL})
    public String graphiqlInterface() {
        return "/static/graphiql.html";
    }

    @RequestMapping(
            value = "/api",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE
    )
    @ResponseBody
    public GridResponse executeGraphQL(
            @RequestBody GridRequest request,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        Map<String, Object> variables = request.getVariables();
        if (variables == null) {
            variables = Collections.emptyMap();
        }
        return gridService.executeGraphQL(request.getOperationName(), request.getQuery(), variables);
    }
}
