package ru.yandex.direct.web.entity.grid.model;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.commons.collections4.CollectionUtils;

/**
 * Стандартный ответ на запрос к GraphQL-контроллеру + флаг success = errors.isEmpty()
 * <p>
 * Для соответствия спецификации не возвращаем отсутствующие data, errors и extensions
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GridResponse {
    private Object data;
    private List<Object> errors;
    private Map<Object, Object> extensions;

    public boolean getSuccess() {
        return CollectionUtils.isEmpty(errors);
    }

    public void setData(Object data) {
        this.data = data;
    }

    public GridResponse withData(Object data) {
        this.data = data;
        return this;
    }

    public Object getData() {
        return data;
    }

    public void setErrors(List<Object> errors) {
        this.errors = errors;
    }

    public GridResponse withErrors(List<Object> errors) {
        this.errors = errors;
        return this;
    }

    public List<Object> getErrors() {
        return errors;
    }

    public void setExtensions(Map<Object, Object> extensions) {
        this.extensions = extensions;
    }

    public GridResponse withExtensions(Map<Object, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public Map<Object, Object> getExtensions() {
        if (extensions != null && extensions.isEmpty()) {
            return null;
        }
        return extensions;
    }
}
