package ru.yandex.direct.web.entity.internalads.controller;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.entity.internalads.model.AddProductAccessResponse;
import ru.yandex.direct.web.entity.internalads.model.GetUsersResponse;
import ru.yandex.direct.web.entity.internalads.model.ModifyProductAccess;
import ru.yandex.direct.web.entity.internalads.model.RemoveProductAccess;
import ru.yandex.direct.web.entity.internalads.model.UpdateProductAccessResponse;
import ru.yandex.direct.web.entity.internalads.service.InternalAdUserWebService;

import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_ADMIN;
import static ru.yandex.direct.rbac.RbacRole.SUPER;
import static ru.yandex.direct.rbac.RbacRole.SUPERREADER;

@Controller
@RequestMapping(value = "/internalads/managers", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "internalads-managers")
@AllowedSubjectRoles({SUPER, INTERNAL_AD_ADMIN})
public class ManagersController {

    private static final String CLIENT_ID = "clientId";

    private final InternalAdUserWebService internalAdUserWebService;

    public ManagersController(InternalAdUserWebService internalAdUserWebService) {
        this.internalAdUserWebService = internalAdUserWebService;
    }

    @ApiOperation(
            value = "getManagers",
            httpMethod = "GET",
            nickname = "getManagers"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = GetUsersResponse.class)
            }
    )
    @RequestMapping(path = "/list", method = RequestMethod.GET)
    @AllowedSubjectRoles({SUPER, SUPERREADER, INTERNAL_AD_ADMIN})
    @ResponseBody
    public WebResponse getManagers(@RequestParam(value = CLIENT_ID, required = false) Long clientId) {

        if (clientId != null) {
            return internalAdUserWebService.getManager(ClientId.fromLong(clientId));
        }
        return internalAdUserWebService.getManagersList();
    }

    @ApiOperation(
            value = "updateAccess",
            httpMethod = "POST",
            nickname = "updateAccess"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = UpdateProductAccessResponse.class)
            }
    )
    @RequestMapping(path = "/update_access", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse updateProductAccess(@RequestBody ModifyProductAccess updateProductsAccess,
                                           @RequestParam(value = CLIENT_ID) Long clientId) {
        return internalAdUserWebService.updateManagerProductAccess(ClientId.fromLong(clientId), updateProductsAccess);
    }

    @ApiOperation(
            value = "addAccess",
            httpMethod = "POST",
            nickname = "addAccess"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = AddProductAccessResponse.class)
            }
    )
    @RequestMapping(path = "/add-access", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse addProductAccess(@RequestBody ModifyProductAccess addProductsAccess,
                                        @RequestParam(value = CLIENT_ID) Long clientId) {

        return internalAdUserWebService.addUserProductAccess(ClientId.fromLong(clientId), addProductsAccess);

    }

    @ApiOperation(
            value = "removeAccess",
            httpMethod = "POST",
            nickname = "removeAccess"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @RequestMapping(path = "/remove-access", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse removeProductAccess(@RequestBody List<RemoveProductAccess> productIds,
                                           @RequestParam(value = CLIENT_ID) Long clientId) {
        return internalAdUserWebService.removeUserProductAccess(ClientId.fromLong(clientId), productIds);
    }
}


