package ru.yandex.direct.web.entity.internalads.controller;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.entity.internalads.service.PlaceService;
import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.entity.internalads.model.GetPlacesListResponse;

import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_ADMIN;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_MANAGER;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.SUPER;
import static ru.yandex.direct.rbac.RbacRole.SUPERREADER;

@ParametersAreNonnullByDefault
@Controller
@RequestMapping(value = "/internalads/places", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "internalads-places")
@AllowedSubjectRoles({SUPER, SUPERREADER,
        INTERNAL_AD_ADMIN, INTERNAL_AD_MANAGER, INTERNAL_AD_SUPERREADER})
public class PlacesController {
    private final PlaceService placeService;

    public PlacesController(PlaceService placeService) {
        this.placeService = placeService;
    }

    @ApiOperation(
            value = "list",
            httpMethod = "GET",
            nickname = "internalads-places-list"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = GetPlacesListResponse.class)
            }
    )
    @GetMapping(path = "/list")
    @ResponseBody
    public WebResponse getPlaces() {
        return new GetPlacesListResponse()
                .withResult(placeService.getPlaceInfoForValidPlaces());
    }

}
