package ru.yandex.direct.web.entity.internalads.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class CreateInternalAdProduct {

    public static final String PRODUCT_NAME = "productName";
    public static final String PRODUCT_DESCRIPTION = "productDescription";
    public static final String PRODUCT_IS_SOFTWARE = "productIsSoftware";

    @JsonProperty(PRODUCT_NAME)
    public String productName;

    @JsonProperty(PRODUCT_DESCRIPTION)
    public String productDescription;

    @JsonProperty(PRODUCT_IS_SOFTWARE)
    public Boolean productIsSoftware;

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public CreateInternalAdProduct withProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public String getProductDescription() {
        return productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public CreateInternalAdProduct withProductDescription(String productDescription) {
        this.productDescription = productDescription;
        return this;
    }

    public Boolean getProductIsSoftware() {
        return productIsSoftware;
    }

    public void setProductIsSoftware(Boolean productIsSoftware) {
        this.productIsSoftware = productIsSoftware;
    }

    public CreateInternalAdProduct withProductIsSoftware(Boolean productIsSoftware) {
        this.productIsSoftware = productIsSoftware;
        return this;
    }

}
