package ru.yandex.direct.web.entity.internalads.model;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class ModifyProductAccess {

    public static final String PRODUCT_ID = "productId";
    public static final String ACCESS_TYPE = "accessType";
    public static final String PLACE_IDS = "placeIds";

    @JsonProperty(PRODUCT_ID)
    public Long productClientId;

    @JsonProperty(ACCESS_TYPE)
    public WebProductAccessType accessType;

    @JsonProperty(PLACE_IDS)
    public Set<Long> placeIds;


    public Long getProductClientId() {
        return productClientId;
    }

    public void setProductClientId(Long productClientId) {
        this.productClientId = productClientId;
    }

    public ModifyProductAccess withProductClientId(Long clientId) {
        this.productClientId = clientId;
        return this;
    }

    public WebProductAccessType getAccessType() {
        return accessType;
    }

    public void setAccessType(WebProductAccessType accessType) {
        this.accessType = accessType;
    }

    public ModifyProductAccess withAccessType(WebProductAccessType userAccessType) {
        this.accessType = userAccessType;
        return this;
    }

    public Set<Long> getPlaceIds() {
        return placeIds;
    }

    public void setPlaceIds(Set<Long> placeIds) {
        this.placeIds = placeIds;
    }

    public ModifyProductAccess withPlaceIds(Set<Long> placeIds) {
        this.placeIds = placeIds;
        return this;
    }
}
