package ru.yandex.direct.web.entity.internalads.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class UpdateInternalAdProduct {

    public static final String PRODUCT_ID = "productId";
    public static final String PRODUCT_DESCRIPTION = "productDescription";
    public static final String PRODUCT_IS_SOFTWARE = "productIsSoftware";

    @JsonProperty(PRODUCT_ID)
    public Long clientId;

    @JsonProperty(PRODUCT_DESCRIPTION)
    public String productDescription;

    @JsonProperty(PRODUCT_IS_SOFTWARE)
    public Boolean productIsSoftware;

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public UpdateInternalAdProduct withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getProductDescription() {
        return productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public UpdateInternalAdProduct withProductDescription(String productDescription) {
        this.productDescription = productDescription;
        return this;
    }

    public Boolean getProductIsSoftware() {
        return productIsSoftware;
    }

    public void setProductIsSoftware(Boolean productIsSoftware) {
        this.productIsSoftware = productIsSoftware;
    }

    public UpdateInternalAdProduct withProductIsSoftware(Boolean productIsSoftware) {
        this.productIsSoftware = productIsSoftware;
        return this;
    }

}
