package ru.yandex.direct.web.entity.internalads.model;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.rbac.model.ClientsRelationType;

@ParametersAreNonnullByDefault
public class WebInternalAdProduct {

    public static final String PRODUCT_ID = "productId";
    public static final String PRODUCT_NAME = "productName";
    public static final String PRODUCT_DESCRIPTION = "productDescription";
    public static final String PRODUCT_LOGIN = "productLogin";
    public static final String PRODUCT_ACCESS = "productAccess";
    public static final String PRODUCT_PLACE_IDS = "productPlaceIds";
    public static final String PRODUCT_IS_SOFTWARE = "productIsSoftware";

    @JsonProperty(PRODUCT_ID)
    public Long productClientId;

    @JsonProperty(PRODUCT_NAME)
    public String productName;

    @JsonProperty(PRODUCT_DESCRIPTION)
    public String productDescription;

    @JsonProperty(PRODUCT_LOGIN)
    public String productLogin;

    @JsonProperty(PRODUCT_ACCESS)
    public ClientsRelationType productAccess;

    @JsonProperty(PRODUCT_PLACE_IDS)
    public Set<Long> productPlaceIds;

    @JsonProperty(PRODUCT_IS_SOFTWARE)
    public Boolean productIsSoftware;

    public Long getProductClientId() {
        return productClientId;
    }

    public void setProductClientId(Long productClientId) {
        this.productClientId = productClientId;
    }

    public WebInternalAdProduct withClientId(Long clientId) {
        this.productClientId = clientId;
        return this;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public WebInternalAdProduct withProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public String getProductDescription() {
        return productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public WebInternalAdProduct withProductDescription(String productDescription) {
        this.productDescription = productDescription;
        return this;
    }

    public String getProductLogin() {
        return productLogin;
    }

    public void setProductLogin(String productLogin) {
        this.productLogin = productLogin;
    }

    public WebInternalAdProduct withProductLogin(String productLogin) {
        this.productLogin = productLogin;
        return this;
    }

    public ClientsRelationType getProductAccess() {
        return productAccess;
    }

    public void setProductAccess(ClientsRelationType productAccess) {
        this.productAccess = productAccess;
    }

    public WebInternalAdProduct withProductAccess(ClientsRelationType productAccess) {
        this.productAccess = productAccess;
        return this;
    }

    @Nullable
    public Set<Long> getProductPlaceIds() {
        return productPlaceIds;
    }

    public void setProductPlaceIds(@Nullable Set<Long> productPlaceIds) {
        this.productPlaceIds = productPlaceIds;
    }

    public WebInternalAdProduct withProductPlaceIds(@Nullable Set<Long> productPlaceIds) {
        this.productPlaceIds = productPlaceIds;
        return this;
    }

    public Boolean getProductIsSoftware() {
        return productIsSoftware;
    }

    public void setProductIsSoftware(Boolean productIsSoftware) {
        this.productIsSoftware = productIsSoftware;
    }

    public WebInternalAdProduct withProductIsSoftware(Boolean productIsSoftware) {
        this.productIsSoftware = productIsSoftware;
        return this;
    }

}
