package ru.yandex.direct.web.entity.internalads.model;

import java.util.Objects;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class WebInternalAdProductAccess {

    public static final String PRODUCT_ID = "productId";
    public static final String PRODUCT_NAME = "productName";
    public static final String PRODUCT_LOGIN = "productLogin";
    public static final String ACCESS_TYPE = "accessType";
    public static final String PLACE_IDS = "placeIds";

    @JsonProperty(PRODUCT_ID)
    public Long productClientId;

    @JsonProperty(PRODUCT_NAME)
    public String productName;

    @JsonProperty(PRODUCT_LOGIN)
    public String productLogin;

    @JsonProperty(ACCESS_TYPE)
    public WebProductAccessType accessType;

    @JsonProperty(PLACE_IDS)
    @Nullable
    public Set<Long> placeIds;


    public Long getProductClientId() {
        return productClientId;
    }

    public void setProductClientId(Long productClientId) {
        this.productClientId = productClientId;
    }

    public WebInternalAdProductAccess withProductClientId(Long clientId) {
        this.productClientId = clientId;
        return this;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public WebInternalAdProductAccess withProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public String getProductLogin() {
        return productLogin;
    }

    public void setProductLogin(String productLogin) {
        this.productLogin = productLogin;
    }

    public WebInternalAdProductAccess withProductLogin(String productLogin) {
        this.productLogin = productLogin;
        return this;
    }

    public WebProductAccessType getAccessType() {
        return accessType;
    }

    public void setAccessType(WebProductAccessType accessType) {
        this.accessType = accessType;
    }

    public WebInternalAdProductAccess withAccessType(WebProductAccessType userAccessType) {
        this.accessType = userAccessType;
        return this;
    }

    @Nullable
    public Set<Long> getPlaceIds() {
        return placeIds;
    }

    public void setPlaceIds(@Nullable Set<Long> placeIds) {
        this.placeIds = placeIds;
    }

    public WebInternalAdProductAccess withPlaceIds(@Nullable Set<Long> placeIds) {
        this.placeIds = placeIds;
        return this;
    }

    @Override
    public String toString() {
        return "WebInternalAdProductAccess{" +
                "productClientId=" + productClientId +
                ", productName='" + productName + '\'' +
                ", productLogin='" + productLogin + '\'' +
                ", accessType=" + accessType +
                ", placeIds=" + placeIds +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebInternalAdProductAccess that = (WebInternalAdProductAccess) o;
        return Objects.equals(productClientId, that.productClientId) &&
                Objects.equals(productName, that.productName) &&
                Objects.equals(productLogin, that.productLogin) &&
                accessType == that.accessType &&
                Objects.equals(placeIds, that.placeIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(productClientId, productName, productLogin, accessType, placeIds);
    }
}
