package ru.yandex.direct.web.entity.internalads.model;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class WebInternalAdUser {

    public static final String CLIENT_ID = "clientId";
    public static final String LOGIN = "productLogin";
    public static final String USERNAME = "username";
    public static final String ACCESS_LIST = "availableProducts";

    @JsonProperty(CLIENT_ID)
    public Long clientId;

    @JsonProperty(LOGIN)
    public String login;

    @JsonProperty(USERNAME)
    public String username;

    @JsonProperty(ACCESS_LIST)
    public List<WebInternalAdProductAccess> accessibleProducts;


    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public WebInternalAdUser withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public WebInternalAdUser withLogin(String login) {
        this.login = login;
        return this;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public WebInternalAdUser withUsername(String username) {
        this.username = username;
        return this;
    }

    public List<WebInternalAdProductAccess> getAccessibleProducts() {
        return accessibleProducts;
    }

    public void setAccessibleProducts(List<WebInternalAdProductAccess> accessibleProducts) {
        this.accessibleProducts = accessibleProducts;
    }

    public WebInternalAdUser withAccessibleProducts(List<WebInternalAdProductAccess> accessibleProducts) {
        this.accessibleProducts = accessibleProducts;
        return this;
    }

    @Override
    public String toString() {
        return "WebInternalAdUser{" +
                "clientId=" + clientId +
                ", login='" + login + '\'' +
                ", username='" + username + '\'' +
                ", accessibleProducts=" + accessibleProducts +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebInternalAdUser that = (WebInternalAdUser) o;
        return Objects.equals(clientId, that.clientId) &&
                Objects.equals(login, that.login) &&
                Objects.equals(username, that.username) &&
                Objects.equals(accessibleProducts, that.accessibleProducts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, login, username, accessibleProducts);
    }
}
