package ru.yandex.direct.web.entity.internalads.presentation;

import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdStringDefectIds;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;

public class InternalAdsDefectPresentation {

    private InternalAdsDefectPresentation() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> internalAdsDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(InternalAdDefectIds.UNKNOWN_CLIENT_ID, defaultWebDefect())
                .register(InternalAdDefectIds.PRODUCT_ACCESS_EXISTS, defaultWebDefect())
                .register(InternalAdDefectIds.PRODUCT_ACCESS_DOES_NOT_EXIST, defaultWebDefect())
                .register(InternalAdDefectIds.PRODUCT_WITH_THIS_NAME_ALREADY_EXISTS, defaultWebDefect())
                .register(InternalAdDefectIds.INVALID_PLACE_ID, defaultWebDefect())
                .register(InternalAdDefectIds.TEMPLATE_NOT_FOUND, defaultWebDefect())
                .register(InternalAdDefectIds.REQUIRED_IMPRESSION_RATE_DUE_TO_RF_CLOSE_BY_CLICK, defaultWebDefect())
                .register(InternalAdStringDefectIds.URL_UNREACHABLE, defaultWebDefect())
                .register(InternalAdStringDefectIds.RESOURCE_RESTRICTIONS_NOT_FOLLOWED, defaultWebDefect())

                .register(InternalAdRestrictionDefects.Url.URL_NOT_VALID, defaultWebDefect())
                .register(InternalAdRestrictionDefects.UrlWithSpaces.URL_HAS_SPACES, defaultWebDefect())
                .register(InternalAdRestrictionDefects.Length.TEXT_TOO_SHORT, defaultWebDefect())
                .register(InternalAdRestrictionDefects.Length.TEXT_TOO_LONG, defaultWebDefect())
                .register(InternalAdRestrictionDefects.Text.TEXT_HAS_SPACES_AROUND, defaultWebDefect())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_TOO_SMALL, defaultWebDefect())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_TOO_BIG, defaultWebDefect())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_NOT_EQUAL, defaultWebDefect())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_NOT_SQUARE, defaultWebDefect())
                .register(InternalAdRestrictionDefects.ImageFormat.IMAGE_FORMAT_INVALID, defaultWebDefect())
                .register(InternalAdRestrictionDefects.ImageSize.IMAGE_SIZE_KB_TOO_BIG, defaultWebDefect())
                .register(InternalAdRestrictionDefects.Gen.FORMAT_INVALID, defaultWebDefect())

                .build();
    }
}
