package ru.yandex.direct.web.entity.internaltools.model;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@ParametersAreNonnullByDefault
public class InternalToolBasicDescription {
    private String name;
    private String label;
    private String description;

    @ApiModelProperty(
            value = "Название инструмента",
            required = true
    )
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public <R extends InternalToolBasicDescription> R withName(String name) {
        this.name = name;
        //noinspection unchecked
        return (R) this;
    }

    @ApiModelProperty(
            value = "Уникальный текстовый идентификатор инструмента",
            required = true
    )
    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public <R extends InternalToolBasicDescription> R withLabel(String label) {
        this.label = label;
        //noinspection unchecked
        return (R) this;
    }

    @ApiModelProperty(
            value = "Описание инструмента",
            required = true
    )
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public <R extends InternalToolBasicDescription> R withDescription(String description) {
        this.description = description;
        //noinspection unchecked
        return (R) this;
    }
}
