package ru.yandex.direct.web.entity.internaltools.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@ParametersAreNonnullByDefault
public class InternalToolCategoryDescription {
    private String name;
    private List<InternalToolBasicDescription> items;

    @ApiModelProperty(
            value = "Название категории",
            required = true
    )
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InternalToolCategoryDescription withName(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(
            value = "Список инструментов в категории",
            required = true
    )
    public List<InternalToolBasicDescription> getItems() {
        return items;
    }

    public void setItems(List<InternalToolBasicDescription> items) {
        this.items = items;
    }

    public InternalToolCategoryDescription withItems(List<InternalToolBasicDescription> items) {
        this.items = items;
        return this;
    }
}
