package ru.yandex.direct.web.entity.internaltools.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.http.HttpMethod;

import ru.yandex.direct.internaltools.core.container.InternalToolResult;

@ApiModel
@ParametersAreNonnullByDefault
public class InternalToolExtendedDescription extends InternalToolBasicDescription {
    private List<String> disclaimers;
    private String action;
    private Boolean canBuildChart;

    private HttpMethod method;
    private List<InternalToolInputGroupRepresentation> inputGroups;
    private InternalToolResult bareRunData;

    @ApiModelProperty(
            value = "Предупреждения",
            required = true
    )
    public List<String> getDisclaimers() {
        return disclaimers;
    }

    public void setDisclaimers(List<String> disclaimers) {
        this.disclaimers = disclaimers;
    }

    public InternalToolExtendedDescription withDisclaimers(List<String> disclaimers) {
        this.disclaimers = disclaimers;
        return this;
    }

    @ApiModelProperty(
            value = "Ожидаемая надпись на кнопке действия",
            required = true
    )
    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public InternalToolExtendedDescription withAction(String action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(
            value = "Метод отправки данных формы",
            required = true
    )
    public HttpMethod getMethod() {
        return method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public InternalToolExtendedDescription withMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @ApiModelProperty(
            value = "Список групп ввода параметров",
            required = true
    )
    public List<InternalToolInputGroupRepresentation> getInputGroups() {
        return inputGroups;
    }

    public void setInputGroups(
            List<InternalToolInputGroupRepresentation> inputGroups) {
        this.inputGroups = inputGroups;
    }

    public InternalToolExtendedDescription withInputGroups(
            List<InternalToolInputGroupRepresentation> inputGroups) {
        this.inputGroups = inputGroups;
        return this;
    }

    @ApiModelProperty(
            value = "Результаты запуска без параметров",
            required = true
    )
    public InternalToolResult getBareRunData() {
        return bareRunData;
    }

    public void setBareRunData(InternalToolResult bareRunData) {
        this.bareRunData = bareRunData;
    }

    public InternalToolExtendedDescription withBareRunData(InternalToolResult bareRunData) {
        this.bareRunData = bareRunData;
        return this;
    }
}
