package ru.yandex.direct.web.entity.internaltools.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@ParametersAreNonnullByDefault
public class InternalToolInputGroupRepresentation {
    private String name;
    private List<InternalToolInputRepresentation> inputs;

    @ApiModelProperty(
            value = "Название группы ввода",
            required = true
    )
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InternalToolInputGroupRepresentation withName(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(
            value = "Список элементов ввода",
            required = true
    )
    public List<InternalToolInputRepresentation> getInputs() {
        return inputs;
    }

    public void setInputs(List<InternalToolInputRepresentation> inputs) {
        this.inputs = inputs;
    }

    public InternalToolInputGroupRepresentation withInputs(List<InternalToolInputRepresentation> inputs) {
        this.inputs = inputs;
        return this;
    }
}
