package ru.yandex.direct.web.entity.internaltools.model;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@ParametersAreNonnullByDefault
public class InternalToolInputRepresentation {
    private String inputType;
    private String label;
    private String name;
    private String description;
    private Map<String, Object> args;
    private Object defaultValue;
    private List<?> allowedValues;
    private Boolean required;

    @ApiModelProperty(
            value = "Тип элемента ввода",
            required = true
    )
    public String getInputType() {
        return inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public InternalToolInputRepresentation withInputType(String inputType) {
        this.inputType = inputType;
        return this;
    }

    @ApiModelProperty(
            value = "Название элемента",
            required = true
    )
    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public InternalToolInputRepresentation withLabel(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(
            value = "Имя элемента (параметр name для инпута)",
            required = true
    )
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InternalToolInputRepresentation withName(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(
            value = "Настройки элемента ввода",
            required = true
    )
    public Map<String, Object> getArgs() {
        return args;
    }

    public void setArgs(Map<String, Object> args) {
        this.args = args;
    }

    public InternalToolInputRepresentation withArgs(Map<String, Object> args) {
        this.args = args;
        return this;
    }

    @ApiModelProperty(
            value = "Значение по умолчанию",
            required = true
    )
    public Object getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public InternalToolInputRepresentation withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @ApiModelProperty(
            value = "Описание элемента ввода",
            required = true
    )
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InternalToolInputRepresentation withDescription(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(
            value = "Обязателен ли элемент",
            required = true
    )
    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public InternalToolInputRepresentation withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public List<?> getAllowedValues() {
        return allowedValues;
    }

    public void setAllowedValues(List<?> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public InternalToolInputRepresentation withAllowedValues(List<?> allowedValues) {
        this.allowedValues = allowedValues;
        return this;
    }
}
