package ru.yandex.direct.web.entity.internaltools.presentations;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.tools.additionaltargetings.validation.AdditionalTargetingsDefectTranslations;
import ru.yandex.direct.internaltools.tools.additionaltargetings.validation.AdditionalTargetingsDeleteDefectIds;
import ru.yandex.direct.internaltools.tools.bs.export.queue.validation.BsExportQueueDefectTranslations;
import ru.yandex.direct.internaltools.tools.ess.sendcampaign.validation.SendCampaignDefectIds;
import ru.yandex.direct.internaltools.tools.ess.sendcampaign.validation.SendCampaignDefectTranslations;
import ru.yandex.direct.internaltools.utils.OneshotDefectIds;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.internaltools.tools.bs.export.queue.validation.BsExportQueueDefectIds.LIMITED_BS_EXPORT_QUEUE_TYPES;
import static ru.yandex.direct.internaltools.tools.bs.export.queue.validation.BsExportQueueDefectIds.MANUAL_CONTROL_OF_WORKERS_NUM_IS_NOT_ENABLED;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

@ParametersAreNonnullByDefault
public class InternalToolsDefectPresentations {

    private InternalToolsDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> bsExportQueueToolsPresentationRegistry() {
        BsExportQueueDefectTranslations translations = BsExportQueueDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(LIMITED_BS_EXPORT_QUEUE_TYPES, webDefect(translations.limitedBsExportQueueType()))
                .register(MANUAL_CONTROL_OF_WORKERS_NUM_IS_NOT_ENABLED,
                        webDefect(translations.manualControlOfWorkersNumIsNotEnabled()))
                .build();
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> sendCampaignContentToolPresentationRegistry() {
        var translations = SendCampaignDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(SendCampaignDefectIds.TIMEOUT_IS_ACTIVE, paramWebDefect(di -> {
                    var params = di.getDefect().params();
                    return translations.timeoutIsActive(
                            params.getObjectsSent(),
                            params.getSecondsRemain());
                }))
                .build();
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> additionalTargetingsToolsPresentationRegistry() {
        AdditionalTargetingsDefectTranslations translations = AdditionalTargetingsDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(AdditionalTargetingsDeleteDefectIds.REQUIRED_AND_POSSIBLE_ONLY_ONE_FIELD,
                        webDefect(translations.requiredAndPossibleOnlyOneField()))
                .build();
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> oneshotRegistry() {
        AdditionalTargetingsDefectTranslations translations = AdditionalTargetingsDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(OneshotDefectIds.REQUIRED_AND_POSSIBLE_ONLY_ONE_FIELD,
                        webDefect(translations.requiredAndPossibleOnlyOneField()))
                .build();
    }
}
