package ru.yandex.direct.web.entity.inventori;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectTranslations;
import ru.yandex.direct.web.entity.inventori.controller.InventoriTranslations;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.inventori.service.validation.InventoriDefectIds.String.UNEXPECTED_INVENTORI_COMMON_PROBLEM;
import static ru.yandex.direct.core.entity.inventori.service.validation.InventoriDefectIds.String.UNEXPECTED_INVENTORI_PROBLEM_WITH_CAMPAIGN;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignDefects.CAMPAIGN_ALREADY_DELETED;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignDefects.CAMPAIGN_NOT_EXISTS;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignTypeDefects.INVALID_CAMPAIGN_TYPE;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.GroupsDefects.INVALID_GROUP_TYPE;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.StrategyDefects.INVALID_CAMPAIGN_STRATEGY;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.CONTAINS_KEYWORD_ADGROUPS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.INTERNAL_ERROR;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.NO_GROUPS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.NO_SUITABLE_ADGROUPS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.UNSUPPORTED_ERROR;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Number.INVALID_BUDGET;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Number.INVALID_CPM;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Number.LOW_REACH;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.INVALID_DATES;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.INVALID_REQUEST;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.INVALID_RF;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.UNKNOWN_SEGMENTS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.UNSUPPORTED_SEGMENTS;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

@ParametersAreNonnullByDefault
public class InventoriDefectPresentations {
    private InventoriDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> inventoriDefectPresentationRegistry() {
        InventoriTranslations translations = InventoriTranslations.INSTANCE;
        InventoriDefectTranslations inventoriDefectTranslations = InventoriDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(LOW_REACH,
                        paramWebDefect(di -> translations.lowReach(di.getDefect().params().getMin())))
                .register(INVALID_BUDGET,
                        defaultWebDefect())
                .register(INVALID_CPM,
                        defaultWebDefect())
                .register(INVALID_DATES,
                        defaultWebDefect())
                .register(INVALID_REQUEST,
                        defaultWebDefect())
                .register(INVALID_RF,
                        defaultWebDefect())
                .register(UNKNOWN_SEGMENTS,
                        defaultWebDefect())
                .register(UNSUPPORTED_SEGMENTS,
                        paramWebDefect(di ->
                                translations.unsupportedSegments(di.getDefect().params().getAllInvalidSubstrings())))
                .register(INTERNAL_ERROR,
                        webDefect(translations.forecastServiceUnavailable()))
                .register(UNSUPPORTED_ERROR,
                        webDefect(translations.forecastServiceUnavailable()))
                .register(NO_SUITABLE_ADGROUPS,
                        defaultWebDefect())
                .register(NO_GROUPS,
                        defaultWebDefect())
                .register(CONTAINS_KEYWORD_ADGROUPS,
                        webDefect(translations.forecastIgnoresKeywordAdGroups()))
                .register(CAMPAIGN_NOT_EXISTS, defaultWebDefect())
                .register(CAMPAIGN_ALREADY_DELETED, defaultWebDefect())
                .register(INVALID_CAMPAIGN_TYPE,
                        paramWebDefect(di -> inventoriDefectTranslations.invalidCampaignType((Long) di.getValue(),
                                di.getDefect().params())))
                .register(INVALID_CAMPAIGN_STRATEGY,
                        paramWebDefect(di -> inventoriDefectTranslations.invalidCampaignStrategy((Long) di.getValue(),
                                di.getDefect().params())))
                .register(INVALID_GROUP_TYPE, defaultWebDefect())
                .register(UNEXPECTED_INVENTORI_PROBLEM_WITH_CAMPAIGN,
                        paramWebDefect(di -> inventoriDefectTranslations.unexpectedInventoryProblemWithCampaign(
                                (Long) di.getValue(), di.getDefect().params().getAllInvalidSubstrings())))
                .register(UNEXPECTED_INVENTORI_COMMON_PROBLEM, defaultWebDefect())
                .build();
    }
}
