package ru.yandex.direct.web.entity.inventori.controller;

import java.io.Serializable;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

public interface InventoriTranslations extends TranslationBundle, Serializable {
    InventoriTranslations INSTANCE = I18NBundle.implement(InventoriTranslations.class);

    @TranslationStub("Сервис прогноза временно недоступен")
    Translatable forecastServiceUnavailable();

    @TranslationStub("Расчет не учитывает группы с типом условия показа \"Фразы\"")
    Translatable forecastIgnoresKeywordAdGroups();

    @MessageFormatStub("Совокупный охват ({0}) очень мал для расчета прогноза CPM. Расширьте таргетинги в условиях показа")
    Translatable lowReach(Number reach);

    @MessageFormatStub("Прогноз рассчитан не по всем группам, т.к. одна или несколько групп содержит следующие сегменты в условии показа: {0}")
    Translatable unsupportedSegments(String segmentList);
}
