package ru.yandex.direct.web.entity.inventori.controller;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.model.WebErrorResponse;

public class InventoriWebErrorResponse extends WebErrorResponse {
    @JsonProperty
    private String requestId;

    public InventoriWebErrorResponse(Integer code, String text) {
        super(code, text);
    }

    public InventoriWebErrorResponse(Integer code, String text, String requestId) {
        super(code, text);
        this.requestId = requestId;
    }

    public InventoriWebErrorResponse withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getRequestId() {
        return requestId;
    }
}
