package ru.yandex.direct.web.entity.inventori.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.entity.inventori.model.CpmForecastSuccessResult;
import ru.yandex.direct.web.entity.SuccessResponse;
import ru.yandex.direct.web.validation.model.WebValidationResult;

@ParametersAreNonnullByDefault
public class CpmForecastResponse extends SuccessResponse<CpmForecastSuccessResult> {

    private WebValidationResult validationResult;
    private String requestId;

    public CpmForecastResponse(@Nullable String requestId, @Nullable CpmForecastSuccessResult result,
                               WebValidationResult validationResult) {
        setResult(result);
        this.requestId = requestId;
        this.validationResult = validationResult;
    }

    @JsonProperty("request_id")
    public String requestId() {
        return requestId;
    }

    @JsonProperty("validation_result")
    public WebValidationResult validationResult() {
        return validationResult;
    }
}
