package ru.yandex.direct.web.entity.inventori.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.entity.inventori.model.GeneralCpmRecommendationSuccessResult;
import ru.yandex.direct.web.entity.SuccessResponse;
import ru.yandex.direct.web.validation.model.WebValidationResult;

public class GeneralRecommendationResponse extends SuccessResponse<GeneralCpmRecommendationSuccessResult> {

    private WebValidationResult validationResult;
    private String requestId;

    public GeneralRecommendationResponse(@Nullable String requestId, @Nullable GeneralCpmRecommendationSuccessResult result,
            WebValidationResult validationResult) {
        setResult(result);
        this.requestId = requestId;
        this.validationResult = validationResult;
    }

    @JsonProperty("request_id")
    public String requestId() {
        return requestId;
    }

    @JsonProperty("validation_result")
    public WebValidationResult validationResult() {
        return validationResult;
    }
}
