package ru.yandex.direct.web.entity.keyword.adqualityexport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Service;

import ru.yandex.direct.web.core.entity.adqualityexport.AdQualityExportActionType;
import ru.yandex.direct.web.core.entity.adqualityexport.AdQualityExportLogEntity;
import ru.yandex.direct.web.core.entity.adqualityexport.AdQualityExportLoggerBase;
import ru.yandex.direct.web.entity.keyword.model.AddAdGroupMinusKeywordsRequestItem;
import ru.yandex.direct.web.entity.keyword.model.AddCampaignMinusKeywordsRequestItem;

@Service
public class AdQualityExportLogger extends AdQualityExportLoggerBase {

    public void logCampaignMinusKeywords(List<AddCampaignMinusKeywordsRequestItem> request,
                                         Map<String, String> origPhraseToNormPhrase) {
        List<AdQualityExportLogEntity> logEntities = getCampaignsLogEntity(request, origPhraseToNormPhrase);
        doLogForExport(logEntities);
    }

    private List<AdQualityExportLogEntity> getCampaignsLogEntity(List<AddCampaignMinusKeywordsRequestItem> request,
                                                                 Map<String, String> origPhraseToNormPhrase) {
        List<AdQualityExportLogEntity> result = new ArrayList<>(request.size());
        for (AddCampaignMinusKeywordsRequestItem requestItem : request) {
            long cid = requestItem.getId();
            List<String> reportRowHashes = requestItem.getReportRowHash();
            if (reportRowHashes == null) {
                //reportRowHashes м.б. null, т.к. выкладка perl и java будут асинхронными
                reportRowHashes = Collections.nCopies(requestItem.getMinusKeywords().size(), null);
            }
            List<AdQualityExportLogEntity> campaignMinusPhrases =
                    StreamEx.of(reportRowHashes)
                            .zipWith(requestItem.getMinusKeywords().stream())
                            .mapKeyValue((rowHash, minusPhrase) -> new AdQualityExportLogEntity()
                                    .withCid(cid)
                                    .withUserProvidedText(minusPhrase)
                                    .withUserNormText(origPhraseToNormPhrase.get(minusPhrase))
                                    .withReportRowHash(rowHash)
                                    .withActionType(AdQualityExportActionType.PZ_CAMP_ADD_NEGATIVE_KEYWORD))
                            .toList();
            result.addAll(campaignMinusPhrases);
        }
        return result;
    }

    public void logAdGroupMinusKeywords(List<AddAdGroupMinusKeywordsRequestItem> request,
                                        Map<String, String> origPhraseToNormPhrase) {
        List<AdQualityExportLogEntity> logEntities = getAdGroupLogEntity(request, origPhraseToNormPhrase);
        doLogForExport(logEntities);
    }

    private List<AdQualityExportLogEntity> getAdGroupLogEntity(List<AddAdGroupMinusKeywordsRequestItem> request,
                                                               Map<String, String> origPhraseToNormPhrase) {
        List<AdQualityExportLogEntity> result = new ArrayList<>(request.size());
        for (AddAdGroupMinusKeywordsRequestItem requestItem : request) {
            long pid = requestItem.getId();
            List<String> reportRowHashes = requestItem.getReportRowHash();
            if (reportRowHashes == null) {
                //reportRowHashes м.б. null, т.к. выкладка perl и java будут асинхронными
                reportRowHashes = Collections.nCopies(requestItem.getMinusKeywords().size(), null);
            }
            List<AdQualityExportLogEntity> groupMinusPhrases =
                    StreamEx.of(reportRowHashes)
                            .zipWith(requestItem.getMinusKeywords().stream())
                            .mapKeyValue((rowHash, minusPhrase) -> new AdQualityExportLogEntity()
                                    .withPid(pid)
                                    .withUserProvidedText(minusPhrase)
                                    .withUserNormText(origPhraseToNormPhrase.get(minusPhrase))
                                    .withReportRowHash(rowHash)
                                    .withActionType(AdQualityExportActionType.PZ_ADGROUP_ADD_NEGATIVE_KEYWORD))
                            .toList();
            result.addAll(groupMinusPhrases);
        }
        return result;
    }
}
