package ru.yandex.direct.web.entity.keyword.controller;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.entity.keyword.model.AddMinusKeywordsRequest;
import ru.yandex.direct.web.entity.keyword.model.CheckMinusKeywordsInclusionRequest;
import ru.yandex.direct.web.entity.keyword.service.AddMinusKeywordService;
import ru.yandex.direct.web.entity.keyword.service.CheckKeywordInclusionService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@ParametersAreNonnullByDefault
@RequestMapping(value = "minus_keyword",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "minusKeyword")
public class MinusKeywordController {

    private final AddMinusKeywordService addMinusKeywordService;
    private final CheckKeywordInclusionService checkKeywordInclusionService;

    @Autowired
    public MinusKeywordController(AddMinusKeywordService addMinusKeywordService,
                                  CheckKeywordInclusionService checkKeywordInclusionService) {
        this.addMinusKeywordService = addMinusKeywordService;
        this.checkKeywordInclusionService = checkKeywordInclusionService;
    }


    @ApiOperation(
            value = "Add minus keywords for campaigns and ad-groups",
            httpMethod = "POST",
            nickname = "add-minus-keywords"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @RequestMapping(path = "add",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse addMinusKeywords(@RequestBody AddMinusKeywordsRequest request,
                                        @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return addMinusKeywordService.addMinusKeywords(request);
    }


    @ApiOperation(
            value = "Get minus-keywords which have full inclusion with some plus keywords",
            httpMethod = "POST",
            nickname = "check-keyword-inclusion"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebResponse.class)
            }
    )
    @PreAuthorizeRead
    @RequestMapping(path = "check_keyword_inclusion",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse checkKeywordInclusion(
            @RequestBody CheckMinusKeywordsInclusionRequest request,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return checkKeywordInclusionService.checkKeywordInclusion(request);
    }
}
