package ru.yandex.direct.web.entity.keyword.converter;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.web.entity.keyword.model.WebKeyword;

import static ru.yandex.direct.core.entity.keyword.service.KeywordUtils.hasAutotargetingPrefix;
import static ru.yandex.direct.core.entity.keyword.service.KeywordUtils.phraseWithoutAutotargetingPrefix;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.utils.NumberUtils.ifNotZero;
import static ru.yandex.direct.utils.NumberUtils.nullIfZero;

public class KeywordConverter {

    private KeywordConverter() {
        // no instantiation
    }

    public static List<Keyword> webKeywordsToCoreKeywords(@Nullable List<WebKeyword> keywordWeb) {
        return mapList(keywordWeb, KeywordConverter::webKeywordToCoreKeyword);
    }

    public static Keyword webKeywordToCoreKeyword(@Nullable WebKeyword webKeyword) {
        if (webKeyword == null) {
            return null;
        }

        return new Keyword()
                .withId(nullIfZero(webKeyword.getId()))
                .withPhrase(phraseWithoutAutotargetingPrefix(webKeyword.getPhrase()))
                .withIsAutotargeting(hasAutotargetingPrefix(webKeyword.getPhrase()))
                .withPrice(ifNotZero(webKeyword.getPrice(), BigDecimal::valueOf))
                .withPriceContext(ifNotZero(webKeyword.getPriceContext(), BigDecimal::valueOf))
                .withAutobudgetPriority(webKeyword.getAutobudgetPriority())
                .withHrefParam1(webKeyword.getParam1())
                .withHrefParam2(webKeyword.getParam2());
    }
}
