package ru.yandex.direct.web.entity.keyword.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Так как фактически операция проводится над группой объявлений,
 * названия полей соответствуют полям группы объявлений уровня веба,
 * чтобы после конвертации результата валидации уровня ядра в результат
 * валидации уровня веба, он соответствовал запросу.
 */
@ApiModel(description = "Список добавляемых минус-фраз для одной группы объявлений")
public class AddAdGroupMinusKeywordsRequestItem {

    public static class Prop {
        private Prop() {
        }

        public static final String ID = "id";
        public static final String MINUS_KEYWORDS = "minus_keywords";
    }

    @JsonProperty(Prop.ID)
    @ApiModelProperty(required = true)
    private Long id;

    @JsonProperty(Prop.MINUS_KEYWORDS)
    @ApiModelProperty(required = true)
    private List<String> minusKeywords;

    @JsonProperty(value = "report_row_hash")
    @ApiModelProperty(required = false)
    private List<String> reportRowHash;

    @SuppressWarnings("unused")
    public AddAdGroupMinusKeywordsRequestItem() {
    }

    public AddAdGroupMinusKeywordsRequestItem(Long id, List<String> minusKeywords) {
        this.id = id;
        this.minusKeywords = minusKeywords;
    }

    public Long getId() {
        return id;
    }

    public List<String> getMinusKeywords() {
        return minusKeywords;
    }

    public List<String> getReportRowHash() {
        return reportRowHash;
    }
}
