package ru.yandex.direct.web.entity.keyword.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "Результат добавления списка минус-фраз для одной группы объявлений")
public class AddAdGroupMinusKeywordsResultItem {

    public static class Prop {
        private Prop() {
        }

        public static final String ID = "id";
        public static final String MINUS_KEYWORDS = "minus_keywords";
        public static final String ADDED_COUNT = "added_count";
        public static final String CURRENT_LENGTH = "current_length";
    }

    @JsonProperty(Prop.ID)
    @ApiModelProperty(required = true)
    private Long id;

    @JsonProperty(Prop.MINUS_KEYWORDS)
    @ApiModelProperty(
            value = "нормализованные минус-фразы в том же порядке, что и в запросе",
            required = true)
    private List<String> minusKeywords;

    @JsonProperty(Prop.ADDED_COUNT)
    @ApiModelProperty(
            value = "количество реально добавленных минус-фраз в группу объявлений",
            required = true)
    private Integer addedCount;

    @JsonProperty(Prop.CURRENT_LENGTH)
    @ApiModelProperty(
            value = "суммарная длина минус-фраз группы объявлений после добавления (без учета спец-символов)",
            required = true)
    private Integer currentLength;

    @SuppressWarnings("unused")
    public AddAdGroupMinusKeywordsResultItem() {
    }

    public AddAdGroupMinusKeywordsResultItem(Long id, List<String> minusKeywords, Integer addedCount,
                                             Integer currentLength) {
        this.id = id;
        this.minusKeywords = minusKeywords;
        this.addedCount = addedCount;
        this.currentLength = currentLength;
    }

    public Long getId() {
        return id;
    }

    public List<String> getMinusKeywords() {
        return minusKeywords;
    }

    public Integer getAddedCount() {
        return addedCount;
    }

    public Integer getCurrentLength() {
        return currentLength;
    }
}
