package ru.yandex.direct.web.entity.keyword.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.web.entity.campaign.model.CampaignWeb;

/**
 * Так как фактически операция проводится над кампанией,
 * названия полей соответствуют полям кампании уровня веба,
 * чтобы после конвертации результата валидации уровня ядра в результат
 * валидации уровня веба, он соответствовал запросу.
 */
@ApiModel(description = "Список добавляемых минус-фраз для одной кампании")
public class AddCampaignMinusKeywordsRequestItem {

    @JsonProperty(CampaignWeb.ID)
    @ApiModelProperty(required = true)
    private Long id;

    @JsonProperty(CampaignWeb.MINUS_KEYWORDS)
    @ApiModelProperty(required = true)
    private List<String> minusKeywords;

    @JsonProperty(value = "report_row_hash")
    @ApiModelProperty(required = false)
    private List<String> reportRowHash;

    @SuppressWarnings("unused")
    public AddCampaignMinusKeywordsRequestItem() {
    }

    public AddCampaignMinusKeywordsRequestItem(Long id, List<String> minusKeywords) {
        this.id = id;
        this.minusKeywords = minusKeywords;
    }

    public Long getId() {
        return id;
    }

    public List<String> getMinusKeywords() {
        return minusKeywords;
    }

    public List<String> getReportRowHash() {
        return reportRowHash;
    }
}
