package ru.yandex.direct.web.entity.keyword.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import ru.yandex.direct.web.entity.WebRequestWithCampaignId;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ApiModel(description = "Добавляемые минус-фразы для кампаний и/или групп объявлений")
public class AddMinusKeywordsRequest implements WebRequestWithCampaignId {

    public static final String CAMPAIGN_MINUS_KEYWORDS = "campaign_minus_keywords";
    public static final String AD_GROUP_MINUS_KEYWORDS = "ad_group_minus_keywords";

    @JsonProperty(CAMPAIGN_MINUS_KEYWORDS)
    private List<AddCampaignMinusKeywordsRequestItem> campaignMinusKeywords;

    @JsonProperty(AD_GROUP_MINUS_KEYWORDS)
    private List<AddAdGroupMinusKeywordsRequestItem> adGroupMinusKeywords;

    @SuppressWarnings("unused")
    public AddMinusKeywordsRequest() {
    }

    public AddMinusKeywordsRequest(List<AddCampaignMinusKeywordsRequestItem> campaignMinusKeywords,
                                   List<AddAdGroupMinusKeywordsRequestItem> adGroupMinusKeywords) {
        this.campaignMinusKeywords = campaignMinusKeywords;
        this.adGroupMinusKeywords = adGroupMinusKeywords;
    }

    public List<AddCampaignMinusKeywordsRequestItem> getCampaignMinusKeywords() {
        return campaignMinusKeywords;
    }

    public List<AddAdGroupMinusKeywordsRequestItem> getAdGroupMinusKeywords() {
        return adGroupMinusKeywords;
    }

    @Override
    public List<Long> getCampaignIds() {
        if (campaignMinusKeywords == null
                || campaignMinusKeywords.isEmpty()) {

            return null;
        }
        return mapList(campaignMinusKeywords, AddCampaignMinusKeywordsRequestItem::getId);
    }

    @Override
    public List<Long> getAdGroupIds() {
        if (adGroupMinusKeywords == null
                || adGroupMinusKeywords.isEmpty()) {

            return null;
        }
        return mapList(adGroupMinusKeywords, AddAdGroupMinusKeywordsRequestItem::getId);
    }
}
