package ru.yandex.direct.web.entity.keyword.model;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import static com.google.common.base.Preconditions.checkArgument;

@SuppressWarnings("unused")
public class AddMinusKeywordsResult {

    @JsonProperty(AddMinusKeywordsRequest.CAMPAIGN_MINUS_KEYWORDS)
    @ApiModelProperty(
            value = "результаты добавления минус-фраз в кампании",
            required = true)
    private List<AddCampaignMinusKeywordsResultItem> campaignMinusKeywordsResults;

    @JsonProperty(AddMinusKeywordsRequest.AD_GROUP_MINUS_KEYWORDS)
    @ApiModelProperty(
            value = "результаты добавления минус-фраз в группы объявлений",
            required = true)
    private List<AddAdGroupMinusKeywordsResultItem> adGroupMinusKeywordsResults;

    public AddMinusKeywordsResult(@Nullable List<AddCampaignMinusKeywordsResultItem> campaignMinusKeywordsResults,
                                  @Nullable List<AddAdGroupMinusKeywordsResultItem> adGroupMinusKeywordsResults) {
        checkArgument(campaignMinusKeywordsResults != null || adGroupMinusKeywordsResults != null,
                "campaign and/or adGroup minus keywords results must be provided");
        this.campaignMinusKeywordsResults = campaignMinusKeywordsResults;
        this.adGroupMinusKeywordsResults = adGroupMinusKeywordsResults;
    }

    public List<AddCampaignMinusKeywordsResultItem> getCampaignMinusKeywordsResults() {
        return campaignMinusKeywordsResults;
    }

    public List<AddAdGroupMinusKeywordsResultItem> getAdGroupMinusKeywordsResults() {
        return adGroupMinusKeywordsResults;
    }
}
