package ru.yandex.direct.web.entity.keyword.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

@SuppressWarnings("unused")
public class CheckMinusKeywordsInclusionRequestItem {

    public static final String MINUS_KEYWORDS_FIELD_NAME = "minus_keywords";
    public static final String ID_FIELD_NAME = "id";

    @JsonProperty(ID_FIELD_NAME)
    private Long id;

    @JsonProperty(MINUS_KEYWORDS_FIELD_NAME)
    private List<String> minusKeywords;

    @ApiModelProperty(required = true)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CheckMinusKeywordsInclusionRequestItem withId(Long id) {
        setId(id);
        return this;
    }

    @ApiModelProperty(name = MINUS_KEYWORDS_FIELD_NAME, required = true)
    public List<String> getMinusKeywords() {
        return minusKeywords;
    }

    public void setMinusKeywords(List<String> minusKeywords) {
        this.minusKeywords = minusKeywords;
    }

    public CheckMinusKeywordsInclusionRequestItem withMinusKeywords(List<String> minusKeyword) {
        setMinusKeywords(minusKeyword);
        return this;
    }
}
