package ru.yandex.direct.web.entity.keyword.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebKeyword {

    public static class Prop {
        private Prop() {
        }

        public static final String ID = "id";
        public static final String PHRASE = "phrase";
        public static final String PRICE = "price";
        public static final String PRICE_CONTEXT = "priceContext";
        public static final String AUTOBUDGET_PRIORITY = "autobudgetPriority";
        public static final String PARAM_1 = "param1";
        public static final String PARAM_2 = "param2";
    }

    @JsonProperty(Prop.ID)
    private Long id;

    @JsonProperty(Prop.PHRASE)
    private String phrase;

    @JsonProperty(Prop.PRICE)
    private Double price;

    @JsonProperty(Prop.PRICE_CONTEXT)
    private Double priceContext;

    @JsonProperty(Prop.AUTOBUDGET_PRIORITY)
    private Integer autobudgetPriority;

    @JsonProperty(Prop.PARAM_1)
    private String param1;

    @JsonProperty(Prop.PARAM_2)
    private String param2;

    public Long getId() {
        return id;
    }

    public WebKeyword withId(Long id) {
        this.id = id;
        return this;
    }

    public String getPhrase() {
        return phrase;
    }

    public WebKeyword withPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    public Double getPrice() {
        return price;
    }

    public WebKeyword withPrice(Double price) {
        this.price = price;
        return this;
    }

    public Double getPriceContext() {
        return priceContext;
    }

    public WebKeyword withPriceContext(Double priceContext) {
        this.priceContext = priceContext;
        return this;
    }

    public Integer getAutobudgetPriority() {
        return autobudgetPriority;
    }

    public WebKeyword withAutobudgetPriority(Integer autobudgetPriority) {
        this.autobudgetPriority = autobudgetPriority;
        return this;
    }

    public String getParam1() {
        return param1;
    }

    public WebKeyword withParam1(String param1) {
        this.param1 = param1;
        return this;
    }

    public String getParam2() {
        return param2;
    }

    public WebKeyword withParam2(String param2) {
        this.param2 = param2;
        return this;
    }
}
