package ru.yandex.direct.web.entity.keyword.presentation;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.keyword.model.WebKeyword;

public class KeywordPathConverters {

    private KeywordPathConverters() {
    }

    public static final MappingPathNodeConverter KEYWORD_PATH_CONVERTER =
            MappingPathNodeConverter.builder(KeywordPathConverters.class.getName())
                    .replace(Keyword.ID.name(), WebKeyword.Prop.ID)
                    .replace(Keyword.AD_GROUP_ID.name(), Keyword.AD_GROUP_ID.name())
                    .replace(Keyword.PHRASE.name(), WebKeyword.Prop.PHRASE)
                    .replace(Keyword.PRICE.name(), WebKeyword.Prop.PRICE)
                    .replace(Keyword.PRICE_CONTEXT.name(), WebKeyword.Prop.PRICE_CONTEXT)
                    .replace(Keyword.AUTOBUDGET_PRIORITY.name(), WebKeyword.Prop.AUTOBUDGET_PRIORITY)
                    .replace(Keyword.HREF_PARAM1.name(), WebKeyword.Prop.PARAM_1)
                    .replace(Keyword.HREF_PARAM2.name(), WebKeyword.Prop.PARAM_2)
                    .build();
}
