package ru.yandex.direct.web.entity.keyword.service.validation;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.entity.keyword.model.CheckMinusKeywordsInclusionRequestItem;

import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator.minusKeywordIsValid;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.unique;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.web.entity.keyword.model.CheckMinusKeywordsInclusionRequestItem.ID_FIELD_NAME;
import static ru.yandex.direct.web.entity.keyword.model.CheckMinusKeywordsInclusionRequestItem.MINUS_KEYWORDS_FIELD_NAME;

@Service
@ParametersAreNonnullByDefault
public class CheckKeywordInclusionValidationService {

    public ValidationResult<List<CheckMinusKeywordsInclusionRequestItem>, Defect> validateRequest(
            List<CheckMinusKeywordsInclusionRequestItem> minusKeyword) {
        return ListValidationBuilder.<CheckMinusKeywordsInclusionRequestItem, Defect>of(minusKeyword)
                .checkEachBy(this::validateRequestItem)
                .checkEach(unique(CheckMinusKeywordsInclusionRequestItem::getId))
                .getResult();
    }

    private ValidationResult<CheckMinusKeywordsInclusionRequestItem, Defect> validateRequestItem(
            CheckMinusKeywordsInclusionRequestItem item) {
        ItemValidationBuilder<CheckMinusKeywordsInclusionRequestItem, Defect> ivb =
                ItemValidationBuilder.of(item);
        ivb.item(item.getId(), ID_FIELD_NAME)
                .check(notNull());

        ivb.list(item.getMinusKeywords(), MINUS_KEYWORDS_FIELD_NAME)
                .check(notNull())
                .checkBy(minusKeywordIsValid(MinusPhraseValidator.ValidationMode.ONE_ERROR_PER_TYPE_AND_KEYWORD));
        return ivb.getResult();
    }
}
