package ru.yandex.direct.web.entity.keyword.stat.controller;

import javax.annotation.Nonnull;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.web.core.model.WebCaptchaResponse;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.security.captcha.CaptchaConditionKey;
import ru.yandex.direct.web.core.security.captcha.CaptchaLimits;
import ru.yandex.direct.web.core.security.captcha.CaptchaSecured;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.core.security.csrf.CsrfCheck;
import ru.yandex.direct.web.entity.keyword.stat.model.KeywordStatShowsBulkRequest;
import ru.yandex.direct.web.entity.keyword.stat.model.KeywordStatShowsBulkResponse;
import ru.yandex.direct.web.entity.keyword.stat.model.KeywordStatShowsRequest;
import ru.yandex.direct.web.entity.keyword.stat.model.KeywordStatShowsResponse;
import ru.yandex.direct.web.entity.keyword.stat.service.KeywordStatShowsService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;
import static ru.yandex.direct.web.core.security.configuration.BlackboxWebAuthenticationConfiguration.PUBLIC_BASE_URL;

@Controller
public class KeywordStatShowsController {

    private final KeywordStatShowsService keywordStatShowsService;

    @Autowired
    public KeywordStatShowsController(KeywordStatShowsService keywordStatShowsService) {
        this.keywordStatShowsService = keywordStatShowsService;
    }

    @ApiOperation(
            value = "keywordsStatShows",
            httpMethod = "POST",
            nickname = "keywordsStatShows"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 429, message = "Too Many Requests", response = WebCaptchaResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = KeywordStatShowsResponse.class),
            }
    )
    @DisableAutoCaptcha
    @CsrfCheck(enabled = false)
    @CaptchaSecured(
            keys = CaptchaConditionKey.IP_VALUE,
            limits = @CaptchaLimits(freq = 50, interval = 3600, maxFreq = 4000))
    @RequestMapping(path = PUBLIC_BASE_URL + "keyword_stat_shows", method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse getKeywordStatShows(@RequestBody @Nonnull KeywordStatShowsRequest keywordStatShowsRequest) {
        return keywordStatShowsService.getKeywordStatShows(keywordStatShowsRequest);
    }

    @ApiOperation(
            value = "privateBulkKeywordsStatShows",
            httpMethod = "POST",
            nickname = "privateBulkKeywordsStatShows"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 429, message = "Too Many Requests", response = WebCaptchaResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = KeywordStatShowsBulkResponse.class),
            }
    )
    @CaptchaSecured(
            keys = CaptchaConditionKey.UID_VALUE,
            limits = @CaptchaLimits(freq = 50, interval = 3600, maxFreq = 4000))
    @RequestMapping(path = "keyword/bulk_keyword_stat_shows", method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse getPrivateBulkKeywordStatShows(
            @RequestBody @Nonnull KeywordStatShowsBulkRequest keywordStatShowsBulkRequest,
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return keywordStatShowsService.getKeywordStatShowsBulk(keywordStatShowsBulkRequest);
    }
}
