package ru.yandex.direct.web.entity.keyword.stat.model;

import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;

import ru.yandex.direct.advq.Age;
import ru.yandex.direct.advq.Device;
import ru.yandex.direct.advq.Gender;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;

public class KeywordStatShowsBulkRequest {

    @JsonProperty("geo")
    private String geo;
    @JsonProperty("commonMinusPhrases")
    private List<String> commonMinusPhrases;
    @JsonProperty("phrases")
    private List<String> phrases;
    @JsonProperty("campaignId")
    private Long campaignId;
    @JsonProperty("adGroupId")
    private Long adGroupId;
    @JsonProperty("libraryMinusPhrasesIds")
    private List<Long> libraryMinusPhrasesIds;
    @JsonProperty("deviceTypes")
    private Set<Device> deviceTypes;
    @JsonProperty("gender")
    private Gender gender;
    @JsonProperty("ages")
    private Set<Age> ages;

    /**
     * {@link GdAdGroupType} тип группы продвижения
     * По умолчанию {@link GdAdGroupType#TEXT}.
     */
    @JsonProperty("adGroupType")
    private GdAdGroupType adGroupType = GdAdGroupType.TEXT;

    /**
     * {@code true}, если ответ должен содержать вложенные фразы {@link KeywordStatShowsBulkEntry#getSearchedWith()}.
     * По умолчанию {@code true}.
     */
    @JsonProperty("needSearchedWith")
    private boolean needSearchedWith = true;

    @JsonProperty("needSearchedAlso")
    private boolean needSearchedAlso = true;

    @JsonProperty("limit")
    private Integer limit;

    public String getGeo() {
        return geo;
    }

    public KeywordStatShowsBulkRequest withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public List<String> getCommonMinusPhrases() {
        return commonMinusPhrases;
    }

    public KeywordStatShowsBulkRequest withCommonMinusPhrases(List<String> commonMinusPhrases) {
        this.commonMinusPhrases = commonMinusPhrases;
        return this;
    }

    public List<String> getPhrases() {
        return phrases;
    }

    public KeywordStatShowsBulkRequest withPhrases(List<String> phrases) {
        this.phrases = phrases;
        return this;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public KeywordStatShowsBulkRequest withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public KeywordStatShowsBulkRequest withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public List<Long> getLibraryMinusPhrasesIds() {
        return libraryMinusPhrasesIds;
    }

    public KeywordStatShowsBulkRequest withLibraryMinusPhrasesIds(List<Long> libraryMinusPhrasesIds) {
        this.libraryMinusPhrasesIds = libraryMinusPhrasesIds;
        return this;
    }

    public boolean getNeedSearchedWith() {
        return needSearchedWith;
    }

    @JsonSetter("needSearchedWith")
    public void setNeedSearchedWith(Boolean needSearchedWith) {
        if (needSearchedWith != null) {
            this.needSearchedWith = needSearchedWith;
        }
    }

    public KeywordStatShowsBulkRequest withNeedSearchedWith(boolean needSearchedWith) {
        setNeedSearchedWith(needSearchedWith);
        return this;
    }

    public boolean getNeedSearchedAlso() {
        return needSearchedAlso;
    }

    @JsonSetter("needSearchedAlso")
    public void setNeedSearchedAlso(Boolean needSearchedAlso) {
        if (needSearchedAlso != null) {
            this.needSearchedAlso = needSearchedAlso;
        }
    }

    public KeywordStatShowsBulkRequest withNeedSearchedAlso(boolean needSearchedAlso) {
        setNeedSearchedWith(needSearchedAlso);
        return this;
    }

    public GdAdGroupType getAdGroupType() {
        return adGroupType;
    }

    @JsonSetter("adGroupType")
    public void setAdGroupType(GdAdGroupType adGroupType) {
        if (adGroupType != null) {
            this.adGroupType = adGroupType;
        }
    }

    public KeywordStatShowsBulkRequest withAdGroupType(GdAdGroupType value) {
        setAdGroupType(value);
        return this;
    }

    public Set<Device> getDeviceTypes() {
        return deviceTypes;
    }

    public KeywordStatShowsBulkRequest withDeviceTypes(Set<Device> deviceTypes) {
        this.deviceTypes = deviceTypes;
        return this;
    }

    public Gender getGender() {
        return gender;
    }

    public KeywordStatShowsBulkRequest withGender(Gender gender) {
        this.gender = gender;
        return this;
    }

    public Set<Age> getAges() {
        return ages;
    }

    public KeywordStatShowsBulkRequest withAges(Set<Age> ages) {
        this.ages = ages;
        return this;
    }

    public Integer getLimit() {
        return limit;
    }
}
