package ru.yandex.direct.web.entity.keyword.stat.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;

import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;

public class KeywordStatShowsRequest {

    @JsonProperty("geo")
    private String geo;
    @JsonProperty("commonMinusPhrases")
    private List<String> commonMinusPhrases;
    @JsonProperty("phrase")
    private String phrase;
    @JsonProperty("campaignId")
    private Long campaignId;
    @JsonProperty("adGroupId")
    private Long adGroupId;
    @JsonProperty("libraryMinusPhrasesIds")
    private List<Long> libraryMinusPhrasesIds;

    /**
     * {@link GdAdGroupType} тип группы продвижения
     * По умолчанию {@link GdAdGroupType#TEXT}.
     */
    @JsonProperty("adGroupType")
    private GdAdGroupType adGroupType = GdAdGroupType.TEXT;

    /**
     * {@code true}, если ответ должен содержать вложенные фразы {@link KeywordStatShowsResponse#getSearchedWith()}.
     * По умолчанию {@code true}.
     */
    @JsonProperty("needSearchedWith")
    private boolean needSearchedWith = true;

    public String getGeo() {
        return geo;
    }

    public KeywordStatShowsRequest withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public List<String> getCommonMinusPhrases() {
        return commonMinusPhrases;
    }

    public KeywordStatShowsRequest withCommonMinusPhrases(List<String> commonMinusPhrases) {
        this.commonMinusPhrases = commonMinusPhrases;
        return this;
    }

    public String getPhrase() {
        return phrase;
    }

    public KeywordStatShowsRequest withPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public KeywordStatShowsRequest withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public KeywordStatShowsRequest withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public List<Long> getLibraryMinusPhrasesIds() {
        return libraryMinusPhrasesIds;
    }

    public KeywordStatShowsRequest withLibraryMinusPhrasesIds(List<Long> libraryMinusPhrasesIds) {
        this.libraryMinusPhrasesIds = libraryMinusPhrasesIds;
        return this;
    }

    public boolean getNeedSearchedWith() {
        return needSearchedWith;
    }

    @JsonSetter("needSearchedWith")
    public void setNeedSearchedWith(Boolean needSearchedWith) {
        if (needSearchedWith != null) {
            this.needSearchedWith = needSearchedWith;
        }
    }

    public KeywordStatShowsRequest withNeedSearchedWith(boolean needSearchedWith) {
        setNeedSearchedWith(needSearchedWith);
        return this;
    }

    public GdAdGroupType getAdGroupType() {
        return adGroupType;
    }

    @JsonSetter("adGroupType")
    public void setAdGroupType(GdAdGroupType adGroupType) {
        if (adGroupType != null) {
            this.adGroupType = adGroupType;
        }
    }

    public KeywordStatShowsRequest withAdGroupType(GdAdGroupType value) {
        setAdGroupType(value);
        return this;
    }
}
