package ru.yandex.direct.web.entity.keyword.stat.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.model.WebSuccessResponse;

public class KeywordStatShowsResponse extends WebSuccessResponse {

    @JsonProperty("searchedWith")
    private List<KeywordStatShowsItem> searchedWith;

    @JsonProperty("searchedAlso")
    private List<KeywordStatShowsItem> searchedAlso;

    @JsonProperty("advqErrors")
    private List<String> advqErrors;

    public List<KeywordStatShowsItem> getSearchedWith() {
        return searchedWith;
    }

    public KeywordStatShowsResponse withSearchedWith(
            List<KeywordStatShowsItem> searchedWith) {
        this.searchedWith = searchedWith;
        return this;
    }

    public List<KeywordStatShowsItem> getSearchedAlso() {
        return searchedAlso;
    }

    public KeywordStatShowsResponse withSearchedAlso(List<KeywordStatShowsItem> searchedAlso) {
        this.searchedAlso = searchedAlso;
        return this;
    }

    public List<String> getAdvqErrors() {
        return advqErrors;
    }

    public KeywordStatShowsResponse withAdvqErrors(List<String> advqErrors) {
        this.advqErrors = advqErrors;
        return this;
    }
}
