package ru.yandex.direct.web.entity.keyword.stat.service;

import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.entity.keyword.stat.model.KeywordStatShowsBulkRequest;

import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseSyntaxValidator.keywordSyntaxValidator;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.CAMPAIGN_MINUS_KEYWORDS_MAX_LENGTH;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.GROUP_MINUS_KEYWORDS_MAX_LENGTH;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.maxLengthKeywordsWithoutSpecSymbolsAndSpaces;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

@Service
public class KeywordStatShowsValidationService {

    private static final int PHRASE_MAX_LENGTH = 4096;
    static final int COMMON_MINUS_WORDS_MAX_LENGTH =
            CAMPAIGN_MINUS_KEYWORDS_MAX_LENGTH + GROUP_MINUS_KEYWORDS_MAX_LENGTH + PHRASE_MAX_LENGTH;

    public ValidationResult<KeywordStatShowsBulkRequest, Defect> validate(KeywordStatShowsBulkRequest bulkRequest) {
        ItemValidationBuilder<KeywordStatShowsBulkRequest, Defect> v =
                ItemValidationBuilder.of(bulkRequest, Defect.class);

        v.check(notNull());
        if (bulkRequest == null) {
            return v.getResult();
        }
        v.item(bulkRequest.getGeo(), "geo")
                .check(notNull())
                .check(notBlank());

        v.list(bulkRequest.getCommonMinusPhrases(), "commonMinusPhrases")
                .checkEach(notNull())
                .checkEach(notBlank())
                .check(maxLengthKeywordsWithoutSpecSymbolsAndSpaces(COMMON_MINUS_WORDS_MAX_LENGTH), When.isValid());

        v.list(bulkRequest.getPhrases(), "phrases")
                .check(notNull())
                .check(notEmptyCollection())
                .checkEachBy(keywordSyntaxValidator())
                .checkEach(maxStringLength(PHRASE_MAX_LENGTH));

        return v.getResult();
    }
}
