package ru.yandex.direct.web.entity.misprints.service

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.misprints.MisprintFixlistService

@Service
open class CheckMisprintService @Autowired constructor(
        private val misprintFixlistService: MisprintFixlistService
) {

    /**
     * Проверяет, нет ли во входной строке "плохих" слов, и отдает такие, если нашлись
     *
     * @param textToCheck строка, которую надо проверить на наличие "плохих" слов
     * @return мапа, где ключ — индекс начала слова в исходной строке, а значение — "плохое" слово
     */
    fun checkMisprints(textToCheck: String): Map<Int, String> {
        val splitted = splitText(textToCheck)
        val misprintsFixlist = misprintFixlistService.getMisprints()
        return splitted
                .filterValues { word -> misprintsFixlist.any { misprint -> misprint.equals(word, true) } }
                .toMap()
    }

    /**
     * Разбивает входную строку на слова разделенные любыми пробельными символами
     *
     * @param textToSplit строка, которую надо разбить на слова
     * @return мапа, где ключ — индекс начала слова в исходной строке, а значение — слово
     */
    fun splitText(textToSplit: String): Map<Int, String> {
        val result: MutableMap<Int, String> = mutableMapOf()
        var start = 0;
        var isSpace = textToSplit[0].isWhitespace();
        for (i in textToSplit.indices) {
            if (isSpace && !textToSplit[i].isWhitespace()) {
                start = i
            }
            if (!isSpace && textToSplit[i].isWhitespace()) {
                result[start] = textToSplit.substring(start, i)
            }
            isSpace = textToSplit[i].isWhitespace()
            if (!isSpace && i == textToSplit.indices.last) {
                result[start] = textToSplit.substring(start, textToSplit.indices.last + 1)
            }
        }
        return result
    }

}
