package ru.yandex.direct.web.entity.mobileapptracker;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableSet;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class TrackerUrlUtils {
    private static final Set<String> BRACKETS = ImmutableSet.of("{", "}");
    private static final Pattern VALUE_SPLITTER = Pattern.compile("((?<=[}{])|(?=[}{]))");

    private TrackerUrlUtils() {
    }

    public static String createParamValuePairString(String paramName, @Nullable String value) {
        return TrackerUrlUtils.encode(paramName) + "=" + TrackerUrlUtils.encode(nvl(value, ""));
    }

    private static String encode(String str) {
        return Arrays.stream(VALUE_SPLITTER.split(str))
                .map(v -> {
                    try {
                        return BRACKETS.contains(v) ? v : URLEncoder.encode(v, "utf-8");
                    } catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException(String.format("Couldn't encode value '%s'", str));
                    }
                }).collect(Collectors.joining());
    }

    public static Collector<String, StringBuilder, String> joinUrlCollector() {
        return Collector.of(
                StringBuilder::new,
                TrackerUrlUtils::appendPartToUrl,
                TrackerUrlUtils::appendPartToUrl,
                StringBuilder::toString);
    }

    private static <C extends CharSequence> StringBuilder appendPartToUrl(StringBuilder url, C part) {
        if (url.length() > 0 && url.charAt(url.length() - 1) != '?') {
            url.append('&');
        }
        url.append(part);
        return url;
    }
}
