package ru.yandex.direct.web.entity.mobileapptracker.controller;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.entity.mobileapp.Constants;
import ru.yandex.direct.web.annotations.AllowedOperatorRoles;
import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.model.WebCaptchaResponse;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.entity.mobileapptracker.converter.MobileAppTrackerUrlTemplateConverter;
import ru.yandex.direct.web.entity.mobileapptracker.model.TrackerUrlTemplateListResponse;
import ru.yandex.direct.web.entity.mobileapptracker.model.WebMobileAppTrackerUrlTemplate;

import static ru.yandex.direct.rbac.RbacRole.AGENCY;
import static ru.yandex.direct.rbac.RbacRole.CLIENT;
import static ru.yandex.direct.rbac.RbacRole.EMPTY;
import static ru.yandex.direct.rbac.RbacRole.LIMITED_SUPPORT;
import static ru.yandex.direct.rbac.RbacRole.MANAGER;
import static ru.yandex.direct.rbac.RbacRole.MEDIA;
import static ru.yandex.direct.rbac.RbacRole.PLACER;
import static ru.yandex.direct.rbac.RbacRole.SUPER;
import static ru.yandex.direct.rbac.RbacRole.SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.SUPPORT;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@AllowedOperatorRoles({SUPER, SUPERREADER, SUPPORT, LIMITED_SUPPORT, PLACER, MEDIA, MANAGER, AGENCY, CLIENT, EMPTY})
@AllowedSubjectRoles({SUPER, SUPERREADER, SUPPORT, LIMITED_SUPPORT, PLACER, MEDIA, MANAGER, AGENCY, CLIENT, EMPTY})
@RequestMapping(value = "/tracker_url_template",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "mobile_app")
@SuppressWarnings("unused")
public class MobileAppTrackerController {
    private final MobileAppTrackerUrlTemplateConverter mobileAppTrackerUrlTemplateConverter;

    public MobileAppTrackerController(MobileAppTrackerUrlTemplateConverter mobileAppTrackerUrlTemplateConverter) {
        this.mobileAppTrackerUrlTemplateConverter = mobileAppTrackerUrlTemplateConverter;
    }

    @ApiOperation(
            value = "getTrackerUrlTemplateList",
            nickname = "getTrackerUrlTemplateList",
            httpMethod = "GET"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 429, message = "Too Many Requests", response = WebCaptchaResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = TrackerUrlTemplateListResponse.class)
            }
    )
    @RequestMapping(path = "/list", method = RequestMethod.GET)
    @ResponseBody
    public TrackerUrlTemplateListResponse getTrackerUrlTemplateList(
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        List<WebMobileAppTrackerUrlTemplate> urlTemplates =
                mapList(Constants.TRACKING_SYSTEMS_CLICK, mobileAppTrackerUrlTemplateConverter::convertTemplate);
        return new TrackerUrlTemplateListResponse(urlTemplates);
    }

    @ApiOperation(
            value = "getImpressionUrlTemplateList",
            nickname = "getImpressionUrlTemplateList",
            httpMethod = "GET"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 429, message = "Too Many Requests", response = WebCaptchaResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = TrackerUrlTemplateListResponse.class)
            }
    )
    @RequestMapping(path = "/impression_list", method = RequestMethod.GET)
    @ResponseBody
    public TrackerUrlTemplateListResponse getImpressionUrlTemplateList(
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        List<WebMobileAppTrackerUrlTemplate> urlTemplates =
                mapList(Constants.TRACKING_SYSTEMS_IMPRESSION, mobileAppTrackerUrlTemplateConverter::convertTemplate);
        return new TrackerUrlTemplateListResponse(urlTemplates);
    }
}
