package ru.yandex.direct.web.entity.mobileapptracker.converter;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerUrlParameter;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppTrackerUrlTemplate;
import ru.yandex.direct.web.core.entity.mobilecontent.converter.MobileContentConverter;
import ru.yandex.direct.web.core.entity.mobilecontent.converter.TrackerConverter;
import ru.yandex.direct.web.entity.mobileapptracker.model.WebMobileAppTrackerUrlParameter;
import ru.yandex.direct.web.entity.mobileapptracker.model.WebMobileAppTrackerUrlTemplate;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.utils.converter.Converters.mappingValueConverter;

@Component
public class MobileAppTrackerUrlTemplateConverter {
    private final TranslationService translationService;
    private final TrackerConverter trackerConverter;

    public MobileAppTrackerUrlTemplateConverter(TranslationService translationService,
                                                TrackerConverter trackerConverter) {
        this.translationService = translationService;
        this.trackerConverter = trackerConverter;
    }

    public WebMobileAppTrackerUrlTemplate convertTemplate(MobileAppTrackerUrlTemplate urlTemplate) {
        return WebMobileAppTrackerUrlTemplate.builder()
                .withTrackingSystem(trackerConverter.convertTrackingSystemToWeb(urlTemplate.getTrackingSystem()))
                .withTrackingSystemName(translationService.translate(urlTemplate.getTrackingSystemName()))
                .withBaseUrlTemplate(urlTemplate.getBaseUrlTemplate())
                .withParameters(mapList(urlTemplate.getParameters(), this::convertUrlParameter))
                .build();
    }

    public WebMobileAppTrackerUrlParameter convertUrlParameter(MobileAppTrackerUrlParameter urlParameter) {
        return WebMobileAppTrackerUrlParameter.builder()
                .withName(urlParameter.getName())
                .withDescription(ifNotNull(urlParameter.getDescription(), translationService::translate))
                .withValue(urlParameter.getValue())
                .withOsType(
                        mappingValueConverter(MobileContentConverter.OS_TYPE_MAPPING).convert(urlParameter.getOsType()))
                .build();
    }
}
