package ru.yandex.direct.web.entity.mobileapptracker.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.entity.mobilecontent.model.WebOsType;

import static com.google.common.base.Preconditions.checkNotNull;

@SuppressWarnings("WeakerAccess")
public class WebMobileAppTrackerUrlParameter {
    private final String name;

    @Nullable
    private final String description;

    private final String value;

    // если поле не null, значит этот параметр должен быть обязательно применён к для указаной ОС
    @Nullable
    private final WebOsType osType;

    public WebMobileAppTrackerUrlParameter(String name, @Nullable String description, String value,
                                           @Nullable WebOsType osType) {
        this.name = name;
        this.description = description;
        this.value = value;
        this.osType = osType;
    }

    @JsonProperty(required = true)
    public String getName() {
        return name;
    }

    @JsonProperty(required = true)
    @Nullable
    public String getDescription() {
        return description;
    }

    @JsonProperty(required = true)
    public String getValue() {
        return value;
    }

    @JsonProperty(required = true)
    @Nullable
    public WebOsType getOsType() {
        return osType;
    }

    @JsonProperty(required = true)
    public boolean isRequired() {
        return osType != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    @SuppressWarnings("unused")
    public static final class Builder {
        private String name;
        private String description;
        private String value;
        private WebOsType osType;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public Builder withOsType(@Nullable WebOsType osType) {
            this.osType = osType;
            return this;
        }

        public WebMobileAppTrackerUrlParameter build() {
            return new WebMobileAppTrackerUrlParameter(checkNotNull(name), description, checkNotNull(value), osType);
        }
    }
}
