package ru.yandex.direct.web.entity.mobilecontent.model;

public enum PropagationMode {
    /**
     * Изменения в приложении применяются ко всем объявлениям в кампаниях, где используется приложение, при этом
     * трекинговая ссылка на объявлении заменяется на обновлённую ссылку в приложении, а также полностью заменяется
     * состояние настроек отображаемых аттрибутов.
     */
    APPLY_TO_ANY_RELATED_BANNERS_AND_REPLACE_ALL,

    /**
     * Изменения в приложении применяются только к объявлениям, содержащим трекинговую ссылку, которую можно получить
     * из старой добавлением параметров. На состояние настроек отображаемых аттрибутов накладываются те же изменения,
     * которые запрошены для приложения.
     */
    APPLY_TO_BANNERS_WITH_SAME_TRACKING_URL_AND_REPLACE_CHANGED,

    /**
     * К объявлениям не применяются никакие изменения.
     */
    DO_NOT_APPLY_TO_BANNERS
}
