package ru.yandex.direct.web.entity.mobilecontent.model;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.web.core.entity.mobilecontent.model.DisplayedAttribute;

import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public final class PropagationRequest {
    private final PropagationMode propagationMode;
    private final Long mobileAppId;
    private final Set<DisplayedAttribute> displayedAttributes;
    @Nullable
    private final String trackingSystem;
    @Nullable
    private final String trackingUrl;
    @Nullable
    private final String trackingImpressionUrl;

    /**
     * Описание "запроса" на изменение данных объявлений, при изменении приложения.
     *
     * @param propagationMode     режим примененения изменений
     * @param mobileAppId         идентификатор приложения, изменения которого применяются к связанным объявлениям
     * @param displayedAttributes новое состояние набора отображаемых аттрибутов
     * @param trackingUrl         новая трекинговая ссылка в приложении
     * @param trackingImpressionUrl новая трекинговая ссылка показов
     */
    private PropagationRequest(PropagationMode propagationMode, Long mobileAppId,
                               Set<DisplayedAttribute> displayedAttributes,
                               @Nullable String trackingSystem,
                               @Nullable String trackingUrl,
                               @Nullable String trackingImpressionUrl) {
        this.propagationMode = propagationMode;
        this.mobileAppId = mobileAppId;
        this.displayedAttributes = displayedAttributes;
        this.trackingSystem = trackingSystem;
        this.trackingUrl = trackingUrl;
        this.trackingImpressionUrl = trackingImpressionUrl;
    }

    public PropagationMode getPropagationMode() {
        return propagationMode;
    }

    public Long getMobileAppId() {
        return mobileAppId;
    }

    public Set<DisplayedAttribute> getDisplayedAttributes() {
        return displayedAttributes;
    }

    @Nullable
    public String getTrackingSystem() {
        return trackingSystem;
    }

    @Nullable
    public String getTrackingUrl() {
        return trackingUrl;
    }

    @Nullable
    public String getTrackingImpressionUrl() {
        return trackingImpressionUrl;
    }

    public static PropagationRequestBuilder builder() {
        return new PropagationRequestBuilder();
    }

    public static final class PropagationRequestBuilder {
        private PropagationMode propagationMode;
        private Long mobileAppId;
        private Set<DisplayedAttribute> displayedAttributes;
        @Nullable
        private String trackingSystem;
        @Nullable
        private String trackingUrl;
        @Nullable
        private String trackingImpressionUrl;

        private PropagationRequestBuilder() {
        }

        public PropagationRequestBuilder withPropagationMode(PropagationMode propagationMode) {
            this.propagationMode = propagationMode;
            return this;
        }

        public PropagationRequestBuilder withMobileAppId(Long mobileAppId) {
            this.mobileAppId = mobileAppId;
            return this;
        }

        public PropagationRequestBuilder withDisplayedAttributes(Set<DisplayedAttribute> displayedAttributes) {
            this.displayedAttributes = displayedAttributes;
            return this;
        }

        public PropagationRequestBuilder withTrackingSystem(@Nullable String trackingSystem) {
            this.trackingSystem = trackingSystem;
            return this;
        }

        public PropagationRequestBuilder withTrackingUrl(@Nullable String trackingUrl) {
            this.trackingUrl = trackingUrl;
            return this;
        }

        public PropagationRequestBuilder withTrackingImpressionUrl(@Nullable String trackingImpressionUrl) {
            this.trackingImpressionUrl = trackingImpressionUrl;
            return this;
        }

        public PropagationRequest build() {
            return new PropagationRequest(checkNotNull(propagationMode), checkNotNull(mobileAppId),
                    checkNotNull(displayedAttributes), trackingSystem, trackingUrl, trackingImpressionUrl);
        }
    }
}
