package ru.yandex.direct.web.entity.mobilecontent.model;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.entity.mobilecontent.model.DeviceType;
import ru.yandex.direct.web.core.entity.mobilecontent.model.DisplayedAttribute;
import ru.yandex.direct.web.core.entity.mobilecontent.model.Network;
import ru.yandex.direct.web.core.entity.mobilecontent.model.WebMobileAppTracker;
import ru.yandex.direct.web.core.entity.mobilecontent.model.WebMobileEvent;


public class WebUpdateMobileAppRequest {
    @JsonProperty(required = true)
    public Long id;

    @JsonProperty(required = true)
    public String name;

    @JsonProperty(required = true)
    @Nullable
    public Set<DisplayedAttribute> displayedAttributes;

    @JsonProperty(required = true)
    @Nullable
    public String minOsVersion;

    @JsonProperty(required = true)
    @Nullable
    public Set<DeviceType> deviceTypeTargeting;

    @JsonProperty(required = true)
    @Nullable
    public Set<Network> networkTargeting;

    @JsonProperty()
    @Nullable
    public String domain;

    @JsonProperty(required = true)
    public List<WebMobileAppTracker> trackers;

    @JsonProperty(required = true)
    public PropagationMode propagationMode;

    @JsonProperty
    public Boolean isAppMetrika; // todo удалить в https://st.yandex-team.ru/DIRECT-143135

    @JsonProperty
    @Nullable
    public Long appMetrikaApplicationId;

    @JsonProperty
    @Nullable
    public List<WebMobileEvent> mobileEvents;

    public WebUpdateMobileAppRequest withId(Long id) {
        this.id = id;
        return this;
    }

    public WebUpdateMobileAppRequest withName(String name) {
        this.name = name;
        return this;
    }

    public WebUpdateMobileAppRequest withDisplayedAttributes(@Nullable Set<DisplayedAttribute> displayedAttributes) {
        this.displayedAttributes = displayedAttributes;
        return this;
    }

    public WebUpdateMobileAppRequest withMinOsVersion(@Nullable String minOsVersion) {
        this.minOsVersion = minOsVersion;
        return this;
    }

    public WebUpdateMobileAppRequest withDeviceTypeTargeting(@Nullable Set<DeviceType> deviceTypeTargeting) {
        this.deviceTypeTargeting = deviceTypeTargeting;
        return this;
    }

    public WebUpdateMobileAppRequest withNetworkTargeting(@Nullable Set<Network> networkTargeting) {
        this.networkTargeting = networkTargeting;
        return this;
    }

    public WebUpdateMobileAppRequest withDomain(@Nullable String domain) {
        this.domain = domain;
        return this;
    }

    public WebUpdateMobileAppRequest withTrackers(List<WebMobileAppTracker> trackers) {
        this.trackers = trackers;
        return this;
    }

    public WebUpdateMobileAppRequest withPropagationMode(PropagationMode propagationMode) {
        this.propagationMode = propagationMode;
        return this;
    }

    public WebUpdateMobileAppRequest withAppMetrika(Boolean appMetrika) {
        isAppMetrika = appMetrika;
        return this;
    }

    public WebUpdateMobileAppRequest withAppMetrikaApplicationId(@Nullable Long appMetrikaApplicationId) {
        this.appMetrikaApplicationId = appMetrikaApplicationId;
        return this;
    }

    public WebUpdateMobileAppRequest withMobileEvents(@Nullable List<WebMobileEvent> mobileEvents) {
        this.mobileEvents = mobileEvents;
        return this;
    }
}
