package ru.yandex.direct.web.entity.mobilecontent.presentations;

import ru.yandex.direct.core.entity.mobileapp.MobileAppDefects;
import ru.yandex.direct.core.entity.mobileapp.MobileAppTranslations;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class MobileAppDefectPresentations {
    private MobileAppDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> mobileAppDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(MobileAppDefects.Gen.NO_ACCESS_TO_CHANGE_DOMAIN,
                        webDefect(MobileAppTranslations.INSTANCE.noAccessToChangeDomain()))

                .register(MobileAppDefects.Gen.INVALID_URL,
                        webDefect(MobileAppTranslations.INSTANCE.invalidUrl()))
                .register(MobileAppDefects.Gen.INVALID_APP_STORE_URL,
                        webDefect(MobileAppTranslations.INSTANCE.invalidAppStoreUrl()))
                .register(MobileAppDefects.Gen.INVALID_DOMAIN,
                        webDefect(MobileAppTranslations.INSTANCE.invalidDomain()))
                .register(MobileAppDefects.Gen.TRACKER_URL_DOMAIN_DOES_NOT_MATCH_SELECTED_TRACKER_SYSTEM,
                        webDefect(MobileAppTranslations.INSTANCE.trackerUrlDomainDoesNotMatchSelectedTrackerSystem()))
                .register(MobileAppDefects.Gen.APP_NOT_FOUND,
                        webDefect(MobileAppTranslations.INSTANCE.appNotFound()))
                .register(MobileAppDefects.Gen.TOO_MANY_BANNERS,
                        webDefect(MobileAppTranslations.INSTANCE.tooManyBanners()))
                .register(MobileAppDefects.Gen.PROPAGATION_IS_FAILED,
                        webDefect(MobileAppTranslations.INSTANCE.propagationIsFailed()))
                .register(MobileAppDefects.Gen.CAN_NOT_REMOVE_TRACKING_URL_IN_CPI_CAMPAIGN,
                        webDefect(MobileAppTranslations.INSTANCE.canNotRemoveTrackingUrlInCpiCampaign()))
                .register(MobileAppDefects.Gen.APPMETRIKA_APPLICATION_ALREADY_USED,
                        webDefect(MobileAppTranslations.INSTANCE.appMetrikaApplicationAlreadyUsed()))
                .build();
    }
}
