package ru.yandex.direct.web.entity.mobilecontent.presentations;

import ru.yandex.direct.core.entity.mobileapp.model.MobileApp;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppTracker;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.core.entity.mobilecontent.model.WebMobileApp;
import ru.yandex.direct.web.core.entity.mobilecontent.model.WebMobileAppTracker;

public class MobileAppPathConverters {
    public static final MappingPathNodeConverter MOBILE_APP_PATH_CONVERTER =
            MappingPathNodeConverter.builder(MobileAppPathConverters.class.getName())
                    .replace(MobileApp.TRACKERS.name(), WebMobileApp.TRACKERS)
                    .build();

    public static final MappingPathNodeConverter MOBILE_APP_TRACKER_PATH_CONVERTER =
            MappingPathNodeConverter.builder(MobileAppPathConverters.class.getName())
                    .replace(MobileAppTracker.URL.name(), WebMobileAppTracker.URL)
                    .replace(MobileAppTracker.IMPRESSION_URL.name(), WebMobileAppTracker.IMPRESSION_URL)
                    .replace(MobileAppTracker.USER_PARAMS.name(), WebMobileAppTracker.USER_PARAMS)
                    .build();
}
