package ru.yandex.direct.web.entity.moderation.controller;

import javax.annotation.Nonnull;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonRequestWeb;
import ru.yandex.direct.core.entity.moderationreason.model.ModerationReasonsResponse;
import ru.yandex.direct.core.entity.moderationreason.service.ModerationReasonTextService;
import ru.yandex.direct.web.annotations.AllowedOperatorRoles;
import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.security.csrf.CsrfCheck;

import static ru.yandex.direct.rbac.RbacRole.AGENCY;
import static ru.yandex.direct.rbac.RbacRole.CLIENT;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_ADMIN;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_MANAGER;
import static ru.yandex.direct.rbac.RbacRole.INTERNAL_AD_SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.LIMITED_SUPPORT;
import static ru.yandex.direct.rbac.RbacRole.MANAGER;
import static ru.yandex.direct.rbac.RbacRole.MEDIA;
import static ru.yandex.direct.rbac.RbacRole.PLACER;
import static ru.yandex.direct.rbac.RbacRole.SUPER;
import static ru.yandex.direct.rbac.RbacRole.SUPERREADER;
import static ru.yandex.direct.rbac.RbacRole.SUPPORT;

@RestController
@RequestMapping("moderationreason")
@Api(tags = "moderationreason")
public class ModerationReasonController {
    private final ModerationReasonTextService moderationReasonTextService;

    @Autowired
    public ModerationReasonController(ModerationReasonTextService moderationReasonTextService) {
        this.moderationReasonTextService = moderationReasonTextService;
    }

    @ApiOperation(value = "Возврат текстов причин отклонения",
            response = ModerationReasonsResponse.class)
    @PostMapping(path = "showModReasons",
            consumes = "application/json",
            produces = "application/json"
    )
    @CsrfCheck(enabled = false)
    @AllowedOperatorRoles({SUPER, SUPERREADER, SUPPORT, LIMITED_SUPPORT, PLACER, MEDIA, MANAGER, AGENCY,
            INTERNAL_AD_ADMIN, INTERNAL_AD_MANAGER, INTERNAL_AD_SUPERREADER, CLIENT})
    @AllowedSubjectRoles({SUPER, SUPERREADER, SUPPORT, LIMITED_SUPPORT, PLACER, MEDIA, MANAGER, AGENCY,
            INTERNAL_AD_ADMIN, INTERNAL_AD_MANAGER, INTERNAL_AD_SUPERREADER, CLIENT})
    public ModerationReasonsResponse showModReasons(@RequestBody @Nonnull ModerationReasonRequestWeb request) {
        return moderationReasonTextService.showModReasons(request, request.getBid());
    }
}
